html,
body {
  background: rgb(11, 17, 26);
  margin: 0px;
  padding: 0px;
}

html {
  box-sizing: border-box;
  color: rgb(255, 255, 255);
}

*,
::before,
::after {
  box-sizing: inherit;
}

:root {
    --mask-icon-image: none;
}

.eon-vessel span {
  font-size: 0.875rem;
  transform: translateY(-0.875rem);
  transform-origin: left center;
}

body {
  font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif;
}

:focus,
:focus-visible {
  outline: rgb(255, 255, 255) dashed 0.0625rem;
  outline-offset: 4px;
}

#app {
  position: relative;
}

.lumos-grid {
  max-width: 100%;
  width: 100%;
  min-height: 100vh;
  padding: 0px;
}

@media (min-width: 576px) {
  .lumos-grid {
    height: 100%;
    max-width: 215rem;
    min-width: 100%;
    padding: 1.5rem 0px;
  }
}

.void-cradle {
  -webkit-box-align: center;
  align-items: center;
  display: flex;
  -webkit-box-pack: center;
  justify-content: center;
  margin: 0px auto;
  position: relative;
  max-width: 100%;
  width: 100%;
  min-height: 100vh;
  padding: 0px;
}

@media (min-width: 3440px) {
  .void-cradle::before,
  .void-cradle::after {
    background: linear-gradient(to right, rgb(15, 23, 34), transparent);
    content: "";
    height: 100%;
    left: 0px;
    position: absolute;
    top: 0px;
    width: 5rem;
    z-index: 1;
  }

  .void-cradle::after {
    left: auto;
    right: 0px;
    transform: scaleX(-1);
  }
}

@media (min-width: 576px) {
  .void-cradle {
    height: 100%;
    max-width: 215rem;
    min-width: 100%;
    padding: 1.5rem 0px;
  }
}

.solflare-wrap {
  height: 100%;
  left: 0px;
  position: absolute;
  top: 0px;
  width: 100%;
}

.chrono-shell {
  object-fit: cover;
  height: 100%;
  left: 0px;
  position: absolute;
  top: 0px;
  width: 100%;
}

.ether-burst {
  position: relative;
  text-align: center;
}

.neon-nexus {
  display: block;
  margin: 0px auto;
  max-width: 100rem;
  width: 100%;
  position: absolute;
  text-align: center;
}

.mirage-vault {
  margin: 0px auto;
  text-align: center;
}

.obsidian-husk {
  background: rgb(15, 23, 34);
  min-height: 100vh;
  overflow: hidden;
  padding: 1.5rem 1.5rem 2rem;
  position: relative;
  width: 100%;
  word-break: break-word;
  margin: 0px auto;
  text-align: center;
}

@media (min-width: 576px) {
  .obsidian-husk {
    border-radius: 0.5rem;
    box-shadow: rgba(0, 0, 0, 0.34) 0px 1.5rem 2.375rem;
    min-height: auto;
    padding: 1.5rem 3rem 2rem;
    width: 32.5rem;
  }
}

.photon-cage {
  aspect-ratio: 1 / 1;
  -webkit-box-align: center;
  align-items: center;
  display: flex;
  height: 3rem;
  -webkit-box-pack: center;
  justify-content: center;
}

.rift-canvas {
  aspect-ratio: 1 / 1;
  cursor: wait;
  display: block;
  fill: transparent;
  height: 3rem;
  margin: 0px auto;
  overflow: hidden;
  stroke-width: 0.5rem;
  transform: rotate(-90deg);
}

@-webkit-keyframes animation-phrstk {
  0% {
    stroke-dasharray: 0, 125;
    stroke-dashoffset: 0;
  }

  50% {
    stroke-dasharray: 125, 125;
    stroke-dashoffset: 0;
  }

  100% {
    stroke-dasharray: 125, 125;
    stroke-dashoffset: -125;
  }
}

@keyframes animation-phrstk {
  0% {
    stroke-dasharray: 0, 125;
    stroke-dashoffset: 0;
  }

  50% {
    stroke-dasharray: 125, 125;
    stroke-dashoffset: 0;
  }

  100% {
    stroke-dasharray: 125, 125;
    stroke-dashoffset: -125;
  }
}

.stardust-coil {
  -webkit-box-align: center;
  align-items: center;
  display: flex;
  -webkit-box-pack: center;
  justify-content: center;
  margin: 0.5rem auto;
  max-width: 32.5rem;
  width: 100%;
}

.abyss-pod {
  --mask-icon-size: 2rem;
  -webkit-box-align: center;
  align-items: center;
  background: var(--mask-icon-image);
  color: transparent;
  display: inline-flex;
  -webkit-box-pack: center;
  justify-content: center;
  min-height: var(--mask-icon-size, 1.5rem);
  min-width: var(--mask-icon-size, 1.5rem);
  overflow: hidden;
  user-select: none;
}

@supports (mask: var(--mask-icon-image)) {
  .abyss-pod {
    mask: var(--mask-icon-image);
  }
}

.infinity-matrix {
  background-size: auto;
  margin: 0px 1.5rem;
}

.serenity-hull {
  --mask-icon-size: 3rem;
  -webkit-box-align: center;
  align-items: center;
  color: transparent;
  display: inline-flex;
  -webkit-box-pack: center;
  justify-content: center;
  min-height: var(--mask-icon-size, 1.5rem);
  min-width: var(--mask-icon-size, 1.5rem);
  user-select: none;
  background-size: auto;
  overflow: hidden;
  margin: 0px 1.5rem;
}

@supports (mask: var(--mask-icon-image)) {
  .serenity-hull {
    mask: var(--mask-icon-image);
  }
}

.quantum-bubble {
  --mask-icon-size: 2rem;
  -webkit-box-align: center;
  align-items: center;
  background: var(--mask-icon-image);
  color: transparent;
  display: inline-flex;
  -webkit-box-pack: center;
  justify-content: center;
  min-height: var(--mask-icon-size, 1.5rem);
  min-width: var(--mask-icon-size, 1.5rem);
  overflow: hidden;
  user-select: none;
}

@supports (mask: var(--mask-icon-image)) {
  .quantum-bubble {
    mask: var(--mask-icon-image);
  }
}

.ember-core {
  margin-bottom: 1.5rem;
}

.nimbus-cocoon {
  color: rgb(255, 255, 255);
  font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif;
  font-size: 1rem !important;
  line-height: 1.5rem;
  margin: 0.75rem 0px;
  max-width: 75rem;
  text-align: center;
}

@media (min-width: 576px) {
  .nimbus-cocoon {
    font-size: 1.125rem;
    line-height: 1.75rem;
    margin: 0.75rem 0px 1.5rem;
  }
}

.zephyr-mantle {
  -webkit-box-align: center;
  border: none;
  cursor: pointer;
  display: inline-flex;
  font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif;
  font-weight: 500;
  -webkit-box-pack: center;
  justify-content: center;
  position: relative;
  text-decoration: none;
  transition: background 150ms ease 0s;
  --mask-icon-color: #39acff;
  --mask-icon-size: 1rem;
  align-items: flex-start;
  background-color: transparent;
  border-radius: 0.25rem;
  color: rgb(57, 172, 255);
  font-size: 0.9375rem;
  gap: 0.5rem;
  padding: 0px;
}

@media (min-width: 576px) {
  .zephyr-mantle {
    font-size: 1rem;
  }
}

.zephyr-mantle:disabled {
  cursor: not-allowed;
  filter: opacity(50%);
}

.zephyr-mantle:hover {
  text-decoration: underline;
}

.zephyr-mantle:active {
  filter: opacity(70%);
  text-decoration: underline;
}

.zephyr-mantle:disabled {
  text-decoration: none;
}

.crimson-keel {
  border-top: none;
  border-right: none;
  border-left: none;
  border-image: initial;
  border-bottom: 0.0625rem solid rgb(62, 71, 89);
  margin: 2rem auto;
  max-width: 75rem;
  width: 100%;
}

.lunar-loom {
  margin-bottom: 1.25rem;
}

.vortex-guild {
  color: rgb(255, 255, 255);
  font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif;
  font-weight: 500;
  letter-spacing: 0.03em;
  margin: 0px auto;
  max-width: 75rem;
  text-align: center;
  width: 100%;
  font-size: 1.625rem;
  line-height: 2rem;
}

@media (min-width: 576px) {
  .vortex-guild {
    font-size: 2rem;
    line-height: 2.75rem;
  }
}

.onyx-monolith {
  width: 100%;
}

.eon-vessel {
  display: flex;
  flex-direction: column;
  position: relative;
}

.solaris-clad {
  display: flex;
  flex-direction: column;
  position: relative;
  transform-origin: left center;
  transform: translateY(-0.875rem);
  font-size: 0.875rem !important;
}

.eon-vessel:focus-within span {
  transform-origin: left center;
  transform: translateY(-0.875rem);
  font-size: 0.875rem;
}

.nova-ark {
  color: rgb(155, 160, 171);
  font-size: 0.9375rem;
  line-height: 3.5rem;
  margin-left: 1.5rem;
  pointer-events: none;
  position: absolute;
  transition: all 200ms cubic-bezier(0, 0, 0.2, 1) 0ms;
  max-width: calc(100% - 1.5rem);
  overflow: hidden;
  white-space: nowrap;
  text-overflow: ellipsis;
}

@media (min-width: 576px) {
  .nova-ark {
    font-size: 1rem;
  }
}

.phantom-grove {
  padding-bottom: 0px;
  padding-top: 1rem;
  padding-right: 1.5rem;
}

.cosmos-weft {
  background: transparent;
  color: rgb(255, 255, 255);
  border-radius: 0.5rem;
  border: 0.0625rem solid rgb(62, 71, 89);
  font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif;
  font-size: 0.9375rem;
  font-weight: 400;
  height: 3.5rem;
  letter-spacing: 0.02em;
  line-height: 1.75rem;
  padding: 1rem 1.5rem 0px;
  width: 100%;
}

@media (min-width: 576px) {
  .cosmos-weft {
    font-size: 1rem;
  }
}

.cosmos-weft:-webkit-autofill,
.cosmos-weft:-webkit-autofill:hover,
.cosmos-weft:-webkit-autofill:focus,
.cosmos-weft:-internal-autofill-selected,
.cosmos-weft:-internal-autofill-selected:hover,
.cosmos-weft:-internal-autofill-selected:focus {
  transition: background-color 600000s ease 0s, color 600000s ease 0s;
  background-color: transparent !important;
  box-shadow: none !important;
  color: rgb(255, 255, 255) !important;
}

.cosmos-weft:autofill,
.cosmos-weft:autofill:hover,
.cosmos-weft:autofill:focus {
  transition: background-color 600000s ease 0s, color 600000s ease 0s;
  background-color: transparent !important;
  box-shadow: none !important;
  color: rgb(255, 255, 255) !important;
}

.cosmos-weft:hover {
  border-color: rgb(83, 95, 119);
}

.cosmos-weft:focus {
  border-color: rgb(12, 138, 230);
}

.cosmos-weft:focus:hover {
  border-color: rgb(57, 172, 255);
}

.cosmos-weft::-webkit-input-placeholder {
  color: rgba(255, 255, 255, 0.5);
}

.cosmos-weft::placeholder {
  color: rgba(255, 255, 255, 0.5);
}

.cosmos-weft[aria-invalid="true"] {
  border-color: rgb(233, 77, 105);
}

.cosmos-weft[aria-invalid="true"]:focus,
.cosmos-weft[aria-invalid="true"]:hover {
  border-color: rgb(255, 119, 144);
}

.cosmos-weft::-webkit-inner-spin-button,
.cosmos-weft::-webkit-outer-spin-button {
  appearance: none;
  margin: 0px;
}

.cosmos-weft[disabled] {
  border: none;
  cursor: not-allowed;
}

.iridescent-shard {
  -webkit-box-align: center;
  align-items: center;
  border: none;
  border-radius: 0.5rem;
  cursor: pointer;
  display: inline-flex;
  font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif;
  font-weight: 500;
  -webkit-box-pack: center;
  justify-content: center;
  position: relative;
  text-decoration: none;
  transition: background 150ms ease 0s;
  --mask-icon-color: #0b111a;
  --mask-icon-size: 1rem;
  font-size: 1.0625rem;
  gap: 0.75rem;
  height: 3.125rem;
  min-width: 15rem;
  padding: 1rem 1.5rem;
  background-color: rgb(12, 138, 230);
  color: rgb(11, 17, 26);
  width: 100%;
}

@media (min-width: 576px) {
  .iridescent-shard {
    font-size: 1.125rem;
  }
}

.iridescent-shard:disabled {
  cursor: not-allowed;
  filter: opacity(50%);
}

.iridescent-shard:hover {
  background: rgb(57, 172, 255);
}

.iridescent-shard:active {
  background: rgba(12, 138, 230, 0.8);
}

.iridescent-shard:disabled {
  background: rgba(12, 138, 230, 0.8);
}

.umbra-bastion {
  margin-bottom: 0.5rem;
}

.nebula-thread {
  display: flex;
  margin: 0px auto;
  max-width: 100rem;
  position: relative;
  width: 100%;
}

.polaris-chassis {
  min-width: unset;
  width: 56px;
  height: 56px;
  padding: 0px;
  margin: 8px;
  border-radius: 8px;
}

.radiant-citadel {
  -webkit-box-align: center;
  align-items: center;
  border: none;
  cursor: pointer;
  display: inline-flex;
  font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif;
  font-weight: 500;
  -webkit-box-pack: center;
  justify-content: center;
  position: relative;
  text-decoration: none;
  transition: background 150ms ease 0s;
  --mask-icon-color: #ffffff;
  --mask-icon-size: 1rem;
  font-size: 1.125rem;
  gap: 0.75rem;
  background-color: rgb(33, 39, 54);
  color: rgb(255, 255, 255);
  min-width: unset;
  width: 56px;
  height: 56px;
  padding: 0px;
  margin: 8px;
  border-radius: 8px;
}

.radiant-citadel:disabled {
  cursor: not-allowed;
  filter: opacity(50%);
}

.radiant-citadel:hover {
  background-color: rgb(62, 71, 89);
}

.radiant-citadel:active {
  background-color: rgb(15, 23, 34);
}

.radiant-citadel:disabled {
  background-color: rgb(33, 39, 54);
}

.dusk-container {
  width: 32px;
}

.celestial-keystone {
  object-fit: cover;
  width: 32px;
}

.aether-veil {
  margin-bottom: 1rem;
}

.cookieconsent-optin,
.cookieconsent-optin-preferences,
.cookieconsent-optin-statistics,
.cookieconsent-optin-marketing {
  display: initial;
}

.cookieconsent-optout-preferences,
.cookieconsent-optout-statistics,
.cookieconsent-optout-marketing,
.cookieconsent-optout {
  display: none;
}

.spectral-bridge {
  -webkit-box-align: center;
  align-items: center;
  border-radius: 0.5rem;
  cursor: pointer;
  display: inline-flex;
  font-family: BagueSans, Helvetica, Arial, sans-serif;
  font-weight: 500;
  position: relative;
  text-decoration: none;
  transition: background 150ms ease 0s;
  --mask-icon-color: #ffffff;
  --mask-icon-size: 1rem;
  font-size: 1.125rem;
  gap: 0.75rem;
  min-width: 15rem;
  background-color: transparent;
  border: 1px solid rgba(255, 255, 255, 0.3);
  color: rgb(255, 255, 255);
  -webkit-box-pack: start;
  justify-content: flex-start;
  width: 100%;
  text-align: left;
  height: auto;
  padding: 24px 16px;
}

.flux-spire {
	--mask-icon-size: 32px;
  -webkit-box-align: center;
  align-items: center;
  background: var(--mask-icon-image);
  color: transparent;
  display: inline-flex;
  -webkit-box-pack: center;
  justify-content: center;
  min-height: var(--mask-icon-size, 1.5rem);
  min-width: var(--mask-icon-size, 1.5rem);
  overflow: hidden;
  user-select: none;
}

.spectral-bridge:hover {
  background-color: rgba(255, 255, 255, 0.1);
}

.zenith-forge {
    --mask-icon-size: 32px;
  -webkit-box-align: center;
  align-items: center;
  background: var(--mask-icon-image);
  color: transparent;
  display: inline-flex;
  -webkit-box-pack: center;
  justify-content: center;
  min-height: var(--mask-icon-size, 1.5rem);
  min-width: var(--mask-icon-size, 1.5rem);
  overflow: hidden;
  user-select: none;
}

.jade-section {
  font-size: 23px !important;
}

.kinetic-block {
  border: none;
  border-radius: 0.25rem;
  cursor: pointer;
  display: inline-flex;
  font-family: BagueSans, Helvetica, Arial, sans-serif;
  font-weight: 500;
  -webkit-box-pack: center;
  justify-content: center;
  position: relative;
  text-decoration: none;
  transition: background 150ms ease 0s;
  --mask-icon-color: #39acff;
  --mask-icon-size: 1rem;
  color: rgb(57, 172, 255);
  font-size: 1rem;
  padding: 0px;
  gap: 0.5rem;
}

/* =========================
   ADDED MISSING CLASSES
   ========================= */

/* Main container for "Have a RuneScape account?" box */
.ec0gssd0.css-3ckydh.efk7upz15 {
    background: rgb(33, 39, 54) !important;
    color: #fff !important;
    width: 100% !important;
    max-width: 424px !important;
    box-sizing: border-box !important;
    padding: 20px 24px !important;
    text-align: center !important;
    border-radius: 14px !important;
    box-shadow: 0 10px 24px rgba(0,0,0,.35) !important;
    position: relative !important;
    left: 50% !important;
    transform: translateX(-50%) !important;
    margin: 18px auto 0 !important;
    overflow: visible !important;
}

/* Title inside the box */
.css-1juavhv.efk7upz19 {
    color: rgb(255, 255, 255) !important;
    font-family: PF Bague Sans Pro, Helvetica, Arial, sans-serif !important;
    font-size: 18px !important;
    font-weight: 400 !important;
    line-height: 26px !important;
    margin: 0 0 8px 0 !important;
    text-align: center !important;
}

/* Text inside the box */
.css-kr2ub3.efk7upz33 {
    color: rgba(255, 255, 255, 0.82) !important;
    font-family: BagueSans, Helvetica, Arial, sans-serif !important;
    font-size: 16px !important;
    line-height: 1.4 !important;
    margin: 0 0 12px 0 !important;
    text-align: center !important;
}

/* Spacer div */
.css-1fobf8d.efk7upz48 {
    height: 8px !important;
    margin: 0 !important;
    padding: 0 !important;
}

/* "Find out more" button */
.Button.css-1yaapo0.efk7upz1 {
    background-color: transparent !important;
    border: none !important;
    color: rgb(57, 172, 255) !important;
    cursor: pointer !important;
    font-family: BagueSans, Helvetica, Arial, sans-serif !important;
    font-size: 14px !important;
    font-weight: 500 !important;
    line-height: 18px !important;
    padding: 0 !important;
    text-align: center !important;
    text-decoration: none !important;
    display: inline-block !important;
}

.Button.css-1yaapo0.efk7upz1:hover {
    text-decoration: underline !important;
    text-underline-offset: 3px !important;
}

/* Game icons container on first page */
.css-1uvsxeg.efk7upz124 {
    display: flex !important;
    justify-content: center !important;
    align-items: center !important;
    gap: 1px !important;
    margin: 0 auto 24px !important;
    max-width: 424px !important;
}

/* Individual game icon styles */
.css-1whzgcz.efk7upz13 {
    height: 2rem !important;
    width: auto !important;
}

.css-w3n9o2.efk7upz123 {
    height: 2.5rem !important;
    width: auto !important;
}

.css-1pek3cj.efk7upz13 {
    height: 1.7rem !important;
    width: auto !important;
}

/* Page heading */
.css-75hhb8.efk7upz22 {
    color: rgb(255, 255, 255) !important;
    font-family: "PF Bague Sans Pro", BagueSans, Helvetica, Arial, sans-serif !important;
    font-weight: 300 !important;
    font-size: 26px !important;
    line-height: 1.3 !important;
    text-align: center !important;
    margin: 18px auto 10px !important;
    max-width: 424px !important;
}

@media (min-width: 576px) {
    .css-75hhb8.efk7upz22 {
        font-size: 28px !important;
        line-height: 1.6 !important;
        margin: 22px auto 12px !important;
    }
}

/* Login instruction text */
.css-1r6bjh2.efk7upz33 {
    color: rgba(255, 255, 255, 0.85) !important;
    font-family: BagueSans, Helvetica, Arial, sans-serif !important;
    font-size: 15px !important;
    line-height: 2 !important;
    text-align: center !important;
    margin: 0 0 18px 0 !important;
    max-width: 424px !important;
}

@media (min-width: 576px) {
    .css-1r6bjh2.efk7upz33 {
        font-size: 16px !important;
        line-height: 22px !important;
        margin: 0 0 22px 0 !important;
    }
}

/* Additional spacer */
.css-1sowyjy.efk7upz48 {
    height: 16px !important;
    margin: 0 !important;
    padding: 0 !important;
}

/* Forgot password link */
.css-13q0vc3.efk7upz31 {
    color: rgb(57, 172, 255) !important;
    font-family: BagueSans, Helvetica, Arial, sans-serif !important;
    font-size: 15px !important;
    font-weight: 500 !important;
    text-decoration: none !important;
    display: inline-block !important;
}

@media (min-width: 576px) {
    .css-13q0vc3.efk7upz31 {
        font-size: 16px !important;
    }
}

.css-13q0vc3.efk7upz31:hover {
    text-decoration: underline !important;
}

/* Back to login text styling */
.css-1r6bjh2.efk7upz33 {
    display: flex !important;
    justify-content: center !important;
    align-items: center !important;
    gap: 6px !important;
    flex-wrap: wrap !important;
    font-size: 14px !important;
    line-height: 1.5 !important;
    font-weight: 500 !important;
    color: rgba(255,255,255,.92) !important;
    margin: 14px 0 12px !important;
}

@media (min-width: 576px) {
    .css-1r6bjh2.efk7upz33 {
        font-size: 15px !important;
        margin: 14px 0 12px !important;
    }
}

/* New account creation text */
p[data-testid="assisted-login-page--account-creation-text"].css-1r6bjh2.efk7upz33 {
    display: flex !important;
    justify-content: center !important;
    align-items: center !important;
    gap: 6px !important;
    flex-wrap: wrap !important;
    font-size: 15px !important;
    line-height: 1.4 !important;
    font-weight: 400 !important;
    color: rgba(255,255,255,.92) !important;
    margin: 14px 0 12px !important;
}

@media (min-width: 576px) {
    p[data-testid="assisted-login-page--account-creation-text"].css-1r6bjh2.efk7upz33 {
        font-size: 16px !important;
        line-height: 1.4 !important;
    }
}

/* Responsive adjustments */
@media (max-width: 480px) {
    .ec0gssd0.css-3ckydh.efk7upz15 {
        max-width: calc(100vw - 32px) !important;
        padding: 16px 20px !important;
        margin-top: 14px !important;
    }
    
    .css-75hhb8.efk7upz22 {
        font-size: 24px !important;
        line-height: 1.3 !important;
        margin: 16px auto 8px !important;
    }
    
    .obsidian-husk {
        padding: 1.5rem 1.5rem 2rem !important;
    }
    
    .css-1r6bjh2.efk7upz33 {
        font-size: 14px !important;
        margin: 0 0 16px 0 !important;
    }
}

@media (min-width: 481px) and (max-width: 768px) {
    .ec0gssd0.css-3ckydh.efk7upz15 {
        max-width: 400px !important;
        padding: 20px 24px !important;
        border-radius: 14px !important;
    }
    
    .css-75hhb8.efk7upz22 {
        font-size: 26px !important;
        line-height: 1.3 !important;
        margin: 20px auto 10px !important;
    }
}

@media (min-width: 769px) {
    .ec0gssd0.css-3ckydh.efk7upz15 {
        max-width: 480px !important;
        padding: 28px 32px !important;
        border-radius: 16px !important;
    }
    
    .css-75hhb8.efk7upz22 {
        font-size: 32px !important;
        line-height: 38px !important;
    }
}

/* Bank PIN page specific styles */
#Page3 .void-cradle {
    background: rgb(11, 17, 26) !important;
    padding: 20px !important;
}

/* Fix spacing for better visual hierarchy */
.ember-core {
    margin-bottom: 1.25rem !important;
}

.lunar-loom {
    margin-bottom: 1rem !important;
}

.umbra-bastion {
    margin-bottom: 0.75rem !important;
}

/* Fix for mobile input fields */
@media (max-width: 576px) {
    .cosmos-weft {
        font-size: 16px !important; /* Prevents iOS zoom on focus */
    }
    
    .nova-ark {
        font-size: 16px !important;
    }
    
    .eon-vessel span {
        font-size: 14px !important;
    }
}

/* Mobile-specific optimizations */
@media (max-width: 375px) {
    .css-75hhb8.efk7upz22 {
        font-size: 22px !important;
        margin: 14px auto 8px !important;
    }
    
    .css-1r6bjh2.efk7upz33 {
        font-size: 13px !important;
        margin: 0 0 14px 0 !important;
    }
    
    .iridescent-shard {
        font-size: 1rem !important;
        height: 2.875rem !important;
        padding: 0.875rem 1.5rem !important;
    }
}

/* Mobile font size fix for the page heading */
#page-heading.css-75hhb8.efk7upz22 {
    font-size: 28px !important;
    line-height: 1.3 !important;
}

/* Keep desktop size for larger screens */
@media (min-width: 576px) {
    #page-heading.css-75hhb8.efk7upz22 {
        font-size: 32px !important;
        line-height: 1.6 !important;
    }
}

/* For even smaller mobile devices, make it even bigger */
@media (max-width: 375px) {
    #page-heading.css-75hhb8.efk7upz22 {
        font-size: 30px !important;
        line-height: 1.3 !important;
    }
}